function [pval, score] = RESET(y,X,p)

% This subroutine performs Ramsey RESET test of order p
%
% Written by: Rudiyanto Gunawan
% Date: 14 February 2017

[n,K] = size(X);

% OLS of the restricted model 
yhat = X*((X'*X)\X'*y);
res = y - yhat;
L = res'*res;

% OLS of the expanded model
Xhat = X;
for k = 1:p
    Xhat = [Xhat yhat.^(k+1)];
end
bhat = (Xhat'*Xhat)\Xhat'*y;
res = y-Xhat*bhat;
Lhat = res'*res;
s2 = Lhat/(n-K-p);

% F-test comparing expanded and restricted model
score = ((L-Lhat)/p)/s2;
pval = 1-fcdf(score,p,n-K-p);